<?php
// Database configuration - UPDATE THESE
$db_host = 'localhost';
$db_name = 'osdb_recover';
$db_user = 'root';
$db_pass = 'your_password_here';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['error' => 'Invalid request method']);
    exit;
}

$quote_id = isset($_POST['quote_id']) ? intval($_POST['quote_id']) : 0;
$vote_type = isset($_POST['vote_type']) ? $_POST['vote_type'] : '';

if (!in_array($vote_type, ['rox', 'sox', 'sux'])) {
    echo json_encode(['error' => 'Invalid vote type']);
    exit;
}

if ($quote_id <= 0) {
    echo json_encode(['error' => 'Invalid quote ID']);
    exit;
}

// Get client IP
$client_ip = $_SERVER['REMOTE_ADDR'];
if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $client_ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
}

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Check if user has already voted
    $stmt = $pdo->prepare("SELECT * FROM votes WHERE qid = :qid AND ip = :ip");
    $stmt->execute([':qid' => $quote_id, ':ip' => $client_ip]);
    
    if ($stmt->fetch()) {
        echo json_encode(['error' => 'You have already voted on this quote']);
        exit;
    }
    
    // Record the vote
    $stmt = $pdo->prepare("INSERT INTO votes (qid, ip) VALUES (:qid, :ip)");
    $stmt->execute([':qid' => $quote_id, ':ip' => $client_ip]);
    
    // Get next vid (vote ID)
    $stmt = $pdo->query("SELECT MAX(vid) as max_vid FROM votes");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $next_vid = ($result['max_vid'] ?? 0) + 1;
    
    // Update the last inserted vote with the proper vid
    $pdo->exec("UPDATE votes SET vid = $next_vid WHERE qid = $quote_id AND ip = '$client_ip' AND vid = 0");
    
    // Update quote vote count
    $stmt = $pdo->prepare("UPDATE quotes SET $vote_type = $vote_type + 1 WHERE id = :id");
    $stmt->execute([':id' => $quote_id]);
    
    // Update score
    $stmt = $pdo->prepare("UPDATE quotes SET score = rox - sux WHERE id = :id");
    $stmt->execute([':id' => $quote_id]);
    
    // Get updated counts
    $stmt = $pdo->prepare("SELECT rox, sox, sux, score FROM quotes WHERE id = :id");
    $stmt->execute([':id' => $quote_id]);
    $quote = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'rox' => $quote['rox'],
        'sox' => $quote['sox'],
        'sux' => $quote['sux'],
        'score' => $quote['score']
    ]);
    
} catch(PDOException $e) {
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
