<?php
// Database configuration - UPDATE THESE
$db_host = 'localhost';
$db_name = 'osdb_recover';
$db_user = 'root';
$db_pass = 'your_password_here';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$per_page = 25;
$offset = ($page - 1) * $per_page;

$count_stmt = $pdo->query("SELECT COUNT(*) FROM quotes WHERE approved = '1'");
$total_quotes = $count_stmt->fetchColumn();
$total_pages = ceil($total_quotes / $per_page);

$stmt = $pdo->prepare("
    SELECT id, quote, comment, rox, sox, sux, score 
    FROM quotes 
    WHERE approved = '1' 
    ORDER BY score DESC, rox DESC 
    LIMIT :limit OFFSET :offset
");
$stmt->bindValue(':limit', $per_page, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$quotes = $stmt->fetchAll(PDO::FETCH_ASSOC);

include 'header.php';
?>

<h2>Top Rated Quotes</h2>

<?php if (count($quotes) > 0): ?>
    <?php foreach ($quotes as $quote): ?>
        <div class="quote-box" id="quote-<?php echo $quote['id']; ?>">
            <div class="quote-header">Quote #<?php echo $quote['id']; ?></div>
            <div class="quote-text"><?php echo $quote['quote']; ?></div>
            <?php if (!empty($quote['comment'])): ?>
                <div class="quote-comment"><?php echo htmlspecialchars($quote['comment']); ?></div>
            <?php endif; ?>
            <div class="quote-footer">
                <div class="vote-buttons">
                    <button class="vote-btn rox" onclick="vote(<?php echo $quote['id']; ?>, 'rox')">
                        👍 Rocks (<span id="rox-<?php echo $quote['id']; ?>"><?php echo $quote['rox']; ?></span>)
                    </button>
                    <button class="vote-btn sox" onclick="vote(<?php echo $quote['id']; ?>, 'sox')">
                        🤷 Socks (<span id="sox-<?php echo $quote['id']; ?>"><?php echo $quote['sox']; ?></span>)
                    </button>
                    <button class="vote-btn sux" onclick="vote(<?php echo $quote['id']; ?>, 'sux')">
                        👎 Sucks (<span id="sux-<?php echo $quote['id']; ?>"><?php echo $quote['sux']; ?></span>)
                    </button>
                </div>
                <div class="vote-counts">
                    Score: <span class="score <?php echo $quote['score'] > 0 ? 'positive' : ($quote['score'] < 0 ? 'negative' : ''); ?>" id="score-<?php echo $quote['id']; ?>"><?php echo $quote['score']; ?></span> |
                    <a href="quote.php?id=<?php echo $quote['id']; ?>" class="quote-link">permalink</a>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
    
    <?php if ($total_pages > 1): ?>
        <div class="pagination">
            <?php if ($page > 1): ?>
                <a href="?page=1">« First</a>
                <a href="?page=<?php echo $page - 1; ?>">‹ Previous</a>
            <?php endif; ?>
            
            <span class="current">Page <?php echo $page; ?> of <?php echo $total_pages; ?></span>
            
            <?php if ($page < $total_pages): ?>
                <a href="?page=<?php echo $page + 1; ?>">Next ›</a>
                <a href="?page=<?php echo $total_pages; ?>">Last »</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
<?php else: ?>
    <p>No quotes found.</p>
<?php endif; ?>

<?php include 'footer.php'; ?>
