<?php
// Database configuration - UPDATE THESE
$db_host = 'localhost';
$db_name = 'osdb_recover';
$db_user = 'root';
$db_pass = 'your_password_here';

$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quote_text = trim($_POST['quote'] ?? '');
    $comment = trim($_POST['comment'] ?? '');
    
    if (empty($quote_text)) {
        $error = 'Quote cannot be empty';
    } else {
        try {
            $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Get client IP
            $client_ip = $_SERVER['REMOTE_ADDR'];
            if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $client_ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
            }
            
            // Get next ID
            $stmt = $pdo->query("SELECT MAX(id) as max_id FROM quotes");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $next_id = ($result['max_id'] ?? 0) + 1;
            
            // Insert quote
            $stmt = $pdo->prepare("
                INSERT INTO quotes (id, quote, comment, ip, rox, sox, sux, score, approved)
                VALUES (:id, :quote, :comment, :ip, 0, 0, 0, 0, '0')
            ");
            $stmt->execute([
                ':id' => $next_id,
                ':quote' => $quote_text,
                ':comment' => $comment,
                ':ip' => $client_ip
            ]);
            
            $success = true;
        } catch(PDOException $e) {
            $error = 'Database error: ' . $e->getMessage();
        }
    }
}

include 'header.php';
?>

<h2>Submit a Quote</h2>

<?php if ($success): ?>
<div class="message success">
    <strong>Success!</strong> Your quote has been submitted and is pending moderation. Thanks for contributing!
</div>
<?php endif; ?>

<?php if ($error): ?>
<div class="message error">
    <strong>Error:</strong> <?php echo htmlspecialchars($error); ?>
</div>
<?php endif; ?>

<form method="POST" action="submit.php">
    <div>
        <label for="quote">Quote (required):</label>
        <textarea name="quote" id="quote" required placeholder="Paste your quote here. You can use &lt;br /&gt; tags for line breaks."></textarea>
    </div>
    
    <div>
        <label for="comment">Comment (optional):</label>
        <input type="text" name="comment" id="comment" placeholder="Add a comment about this quote">
    </div>
    
    <div>
        <button type="submit">Submit Quote</button>
    </div>
</form>

<div style="margin-top: 30px; padding: 15px; background: #f0f0f0; border-left: 4px solid #333;">
    <h3 style="margin-bottom: 10px;">Submission Guidelines:</h3>
    <ul style="margin-left: 20px; line-height: 1.8;">
        <li>Quotes are submitted anonymously</li>
        <li>All submissions go through moderation before appearing on the site</li>
        <li>Use <code>&lt;br /&gt;</code> tags to separate lines in multi-line quotes</li>
        <li>Keep it funny, interesting, or memorable!</li>
        <li>No personal information, hate speech, or illegal content</li>
    </ul>
</div>

<?php include 'footer.php'; ?>
