<?php
// Database configuration - UPDATE THESE
$db_host = 'localhost';
$db_name = 'osdb_recover';
$db_user = 'root';
$db_pass = 'your_password_here';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

$quote_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($quote_id <= 0) {
    header('Location: index.php');
    exit;
}

$stmt = $pdo->prepare("
    SELECT id, quote, comment, rox, sox, sux, score 
    FROM quotes 
    WHERE id = :id AND approved = '1'
");
$stmt->bindValue(':id', $quote_id, PDO::PARAM_INT);
$stmt->execute();
$quote = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$quote) {
    header('Location: index.php');
    exit;
}

include 'header.php';
?>

<div class="quote-box" id="quote-<?php echo $quote['id']; ?>">
    <div class="quote-header">Quote #<?php echo $quote['id']; ?></div>
    <div class="quote-text"><?php echo $quote['quote']; ?></div>
    <?php if (!empty($quote['comment'])): ?>
        <div class="quote-comment"><?php echo htmlspecialchars($quote['comment']); ?></div>
    <?php endif; ?>
    <div class="quote-footer">
        <div class="vote-buttons">
            <button class="vote-btn rox" onclick="vote(<?php echo $quote['id']; ?>, 'rox')">
                👍 Rocks (<span id="rox-<?php echo $quote['id']; ?>"><?php echo $quote['rox']; ?></span>)
            </button>
            <button class="vote-btn sox" onclick="vote(<?php echo $quote['id']; ?>, 'sox')">
                🤷 Socks (<span id="sox-<?php echo $quote['id']; ?>"><?php echo $quote['sox']; ?></span>)
            </button>
            <button class="vote-btn sux" onclick="vote(<?php echo $quote['id']; ?>, 'sux')">
                👎 Sucks (<span id="sux-<?php echo $quote['id']; ?>"><?php echo $quote['sux']; ?></span>)
            </button>
        </div>
        <div class="vote-counts">
            Score: <span class="score <?php echo $quote['score'] > 0 ? 'positive' : ($quote['score'] < 0 ? 'negative' : ''); ?>" id="score-<?php echo $quote['id']; ?>"><?php echo $quote['score']; ?></span>
        </div>
    </div>
</div>

<div style="text-align: center; margin-top: 20px;">
    <a href="index.php">← Back to recent quotes</a> |
    <a href="random.php">Random quote →</a>
</div>

<?php include 'footer.php'; ?>
