<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quote Database</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Courier New', monospace;
            background-color: #f5f5f5;
            color: #333;
            line-height: 1.6;
            padding: 20px;
        }
        
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        
        header {
            border-bottom: 3px solid #333;
            padding-bottom: 20px;
            margin-bottom: 20px;
        }
        
        h1 {
            font-size: 2em;
            margin-bottom: 10px;
        }
        
        h2 {
            margin-bottom: 20px;
        }
        
        nav {
            margin-top: 15px;
        }
        
        nav a {
            color: #0066cc;
            text-decoration: none;
            margin-right: 20px;
            font-weight: bold;
        }
        
        nav a:hover {
            text-decoration: underline;
        }
        
        .quote-box {
            background: #fafafa;
            border: 2px solid #ddd;
            padding: 15px;
            margin-bottom: 20px;
            position: relative;
        }
        
        .quote-header {
            font-weight: bold;
            margin-bottom: 10px;
            color: #666;
        }
        
        .quote-text {
            white-space: pre-wrap;
            margin-bottom: 15px;
            font-size: 0.95em;
        }
        
        .quote-comment {
            font-style: italic;
            color: #666;
            font-size: 0.9em;
            margin-bottom: 10px;
        }
        
        .quote-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top: 1px solid #ddd;
            padding-top: 10px;
            margin-top: 10px;
        }
        
        .vote-buttons {
            display: flex;
            gap: 10px;
        }
        
        .vote-btn {
            padding: 5px 12px;
            border: 1px solid #333;
            background: white;
            cursor: pointer;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
            transition: all 0.2s;
        }
        
        .vote-btn:hover:not(:disabled) {
            background: #333;
            color: white;
        }
        
        .vote-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .vote-btn.rox { color: green; }
        .vote-btn.sox { color: orange; }
        .vote-btn.sux { color: red; }
        
        .vote-counts {
            font-size: 0.9em;
            color: #666;
        }
        
        .score {
            font-weight: bold;
            font-size: 1.1em;
        }
        
        .score.positive { color: green; }
        .score.negative { color: red; }
        
        .quote-link {
            color: #0066cc;
            text-decoration: none;
            font-size: 0.9em;
        }
        
        .quote-link:hover {
            text-decoration: underline;
        }
        
        .pagination {
            text-align: center;
            margin: 30px 0;
            padding: 20px;
            border-top: 2px solid #ddd;
        }
        
        .pagination a {
            color: #0066cc;
            text-decoration: none;
            margin: 0 10px;
            font-weight: bold;
        }
        
        .pagination a:hover {
            text-decoration: underline;
        }
        
        .pagination .current {
            font-weight: bold;
            color: #333;
        }
        
        form {
            margin: 20px 0;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        textarea, input[type="text"] {
            width: 100%;
            padding: 10px;
            font-family: 'Courier New', monospace;
            border: 2px solid #ddd;
            margin-bottom: 15px;
            font-size: 0.95em;
        }
        
        textarea {
            min-height: 150px;
            resize: vertical;
        }
        
        button[type="submit"], .btn {
            padding: 10px 30px;
            background: #333;
            color: white;
            border: none;
            cursor: pointer;
            font-family: 'Courier New', monospace;
            font-size: 1em;
            font-weight: bold;
        }
        
        button[type="submit"]:hover, .btn:hover {
            background: #555;
        }
        
        .message {
            padding: 15px;
            margin-bottom: 20px;
            border: 2px solid;
        }
        
        .message.success {
            background: #d4edda;
            border-color: #28a745;
            color: #155724;
        }
        
        .message.error {
            background: #f8d7da;
            border-color: #dc3545;
            color: #721c24;
        }
        
        footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #ddd;
            text-align: center;
            color: #666;
            font-size: 0.9em;
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <h1>📝 Quote Database</h1>
            <nav>
                <a href="index.php">Home</a>
                <a href="browse.php">Browse</a>
                <a href="top.php">Top Quotes</a>
                <a href="random.php">Random</a>
                <a href="submit.php">Submit</a>
            </nav>
        </header>
        
        <main>
