# Quote Database - PHP Version

A bash.org-style quote database web application for displaying your recovered IRC quotes.

## Features

- 📖 Browse all quotes with pagination
- 🏆 View top-rated quotes
- 🎲 Random quote viewer
- 👍 Vote on quotes (rocks/socks/sucks)
- ✍️ Anonymous quote submission
- 🔗 Permalink for each quote

## Requirements

- PHP 7.0 or higher
- MySQL 5.6 or higher
- Web server (Apache, Nginx, etc.)

## Installation

### 1. Upload Files

Upload all PHP files to your web server directory:
- index.php
- browse.php
- top.php
- quote.php
- random.php
- submit.php
- vote.php
- header.php
- footer.php
- config.php (optional - for centralized configuration)

### 2. Configure Database

**Option A: Edit each file individually**

Open each PHP file and update these lines at the top:

```php
$db_host = 'localhost';
$db_name = 'osdb_recover';
$db_user = 'your_mysql_username';  // Change this
$db_pass = 'your_mysql_password';  // Change this
```

Files to update: index.php, browse.php, top.php, quote.php, random.php, submit.php, vote.php

**Option B: Use config.php (recommended)**

Edit config.php with your database credentials, then modify each file to use it:

Replace the database configuration section in each file with:
```php
<?php
require_once 'config.php';
$pdo = getDB();
```

### 3. Approve Existing Quotes

If you want all your recovered quotes to be visible immediately:

```sql
UPDATE quotes SET approved = '1' WHERE approved = '0' OR approved = '2';
```

Or keep them moderated and approve manually through phpMyAdmin.

### 4. Set Permissions

Make sure your web server can read all PHP files:

```bash
chmod 644 *.php
```

### 5. Access Your Site

Visit your website in a browser:
- http://yourdomain.com/ (or wherever you uploaded the files)

## File Structure

```
quote-database/
├── index.php         # Home page (recent quotes)
├── browse.php        # Browse all quotes (paginated)
├── top.php          # Top-rated quotes
├── quote.php        # Individual quote view
├── random.php       # Random quote redirect
├── submit.php       # Submit new quotes
├── vote.php         # AJAX voting endpoint
├── header.php       # Shared header and CSS
├── footer.php       # Shared footer and JavaScript
└── config.php       # Database configuration (optional)
```

## Usage

- **Home** - Shows the 25 most recent approved quotes
- **Browse** - Paginated list of all quotes
- **Top Quotes** - Quotes sorted by score (upvotes - downvotes)
- **Random** - Redirects to a random quote
- **Submit** - Submit new quotes anonymously (requires moderation)

## Voting System

- **Rocks** 👍 - Upvote (adds to score)
- **Socks** 🤷 - Neutral vote (no effect on score)
- **Sucks** 👎 - Downvote (subtracts from score)

Each IP address can only vote once per quote.

## Moderation

New quotes are submitted with `approved = '0'`. To approve quotes:

### Using phpMyAdmin:

1. View pending quotes:
   ```sql
   SELECT * FROM quotes WHERE approved = '0' ORDER BY id DESC;
   ```

2. Approve a quote:
   ```sql
   UPDATE quotes SET approved = '1' WHERE id = QUOTE_ID;
   ```

3. Delete spam:
   ```sql
   DELETE FROM quotes WHERE id = QUOTE_ID;
   ```

### Bulk Approval:

Approve all pending quotes at once:
```sql
UPDATE quotes SET approved = '1' WHERE approved = '0';
```

## Customization

### Change Design

Edit `header.php` and modify the CSS in the `<style>` section:
- Colors: Search for color values like `#333`, `#0066cc`, etc.
- Fonts: Change `font-family: 'Courier New'` to your preferred font
- Layout: Modify `.container` max-width, padding, etc.

### Change Quotes Per Page

Edit the `$per_page = 25;` variable in:
- index.php
- browse.php
- top.php

### Change Site Title

Edit `header.php` and modify:
```html
<h1>📝 Quote Database</h1>
```

## Troubleshooting

### "Database connection failed"
- Check your database credentials in each PHP file
- Verify MySQL is running
- Check that the database name is correct
- Ensure your MySQL user has proper permissions

### No quotes showing
- Check if quotes are approved: 
  ```sql
  SELECT COUNT(*) FROM quotes WHERE approved = '1';
  ```
- If 0, run: `UPDATE quotes SET approved = '1';`

### Can't vote
- Check that the votes table exists
- Verify PHP has write access to the database
- Check browser console for JavaScript errors

### Voting not working
- Make sure vote.php is accessible
- Check browser console for errors
- Verify the votes table structure matches expectations

## Security Notes

- The app uses prepared statements to prevent SQL injection
- IP addresses are used for vote tracking (no cookies/sessions)
- XSS protection: Comments are escaped with htmlspecialchars()
- Quote text is NOT escaped to preserve HTML formatting (be careful with untrusted input)

## Database Schema

The app expects these tables:

**quotes table:**
- id (int) - Quote ID
- quote (longtext) - The quote text (may contain HTML)
- comment (text) - Optional comment about the quote
- ip (varchar) - Submitter's IP
- rox (int) - Upvote count
- sox (int) - Neutral vote count
- sux (int) - Downvote count
- score (int) - Calculated score (rox - sux)
- approved (char) - '0'=pending, '1'=approved, '2'=maybe approved

**votes table:**
- vid (int) - Vote ID
- qid (int) - Quote ID
- ip (varchar) - Voter's IP

Enjoy your quote database! 🎉
