# Quote Database - OSDB Revival

A bash.org-style quote database web application for displaying your recovered IRC quotes.

## Features

- 📖 Browse all quotes with pagination
- 🏆 View top-rated quotes
- 🎲 Random quote viewer
- 👍 Vote on quotes (rocks/socks/sucks)
- ✍️ Anonymous quote submission
- 🔗 Permalink for each quote

## Setup Instructions

### 1. Install Dependencies

```bash
pip install -r requirements.txt
```

Or install manually:
```bash
pip install Flask mysql-connector-python
```

### 2. Configure Database Connection

Edit `quote_app.py` and update these lines with your MySQL credentials:

```python
DB_CONFIG = {
    'host': 'localhost',
    'database': 'osdb_recover',
    'user': 'root',  # Change to your MySQL user
    'password': 'your_password_here'  # Change to your MySQL password
}
```

### 3. (Optional) Approve Existing Quotes

If you want all your recovered quotes to be visible immediately, run this SQL command:

```sql
UPDATE quotes SET approved = '1' WHERE approved = '0';
```

Or keep them moderated and approve them manually through phpMyAdmin.

### 4. Run the Application

Development mode (for testing):
```bash
python quote_app.py
```

The app will be available at: http://localhost:5000

### 5. Production Deployment

For production, use a proper WSGI server like gunicorn:

```bash
pip install gunicorn
gunicorn -w 4 -b 0.0.0.0:5000 quote_app:app
```

Or use nginx + uwsgi, Apache + mod_wsgi, etc.

## Usage

- **Home** - Shows the 25 most recent approved quotes
- **Browse** - Paginated list of all quotes
- **Top Quotes** - Quotes sorted by score (upvotes - downvotes)
- **Random** - Redirects to a random quote
- **Submit** - Submit new quotes anonymously (requires moderation)

## Voting System

- **Rocks** 👍 - Upvote (adds to score)
- **Socks** 🤷 - Neutral vote (no effect on score)
- **Sucks** 👎 - Downvote (subtracts from score)

Each IP address can only vote once per quote.

## Database Structure

The app uses these tables from your recovered database:

- `quotes` - Main quote storage
- `votes` - Tracks who voted on what (IP-based)
- Other tables (admins, bans, config, news, templates) are not currently used

## Moderation

New quotes are submitted with `approved = '0'`. To approve quotes:

1. Use phpMyAdmin to view pending quotes:
   ```sql
   SELECT * FROM quotes WHERE approved = '0' ORDER BY id DESC;
   ```

2. Approve a quote by updating its status:
   ```sql
   UPDATE quotes SET approved = '1' WHERE id = QUOTE_ID;
   ```

3. Or reject/delete spam:
   ```sql
   DELETE FROM quotes WHERE id = QUOTE_ID;
   ```

## Customization

- Edit `templates/base.html` to change the site design
- Modify the CSS in the `<style>` section for different colors/fonts
- Update the header/footer text to match your site
- Change items per page by modifying `per_page = 25` in the route functions

## Notes

- The original `<br />` tags in your quotes are preserved for multi-line formatting
- Vote tracking is IP-based (no login required)
- Submitted quotes require manual approval before appearing on the site
- The score is calculated as: `rox - sux` (rocks minus sucks)

## Troubleshooting

**Database connection errors:**
- Check your MySQL credentials in `quote_app.py`
- Ensure MySQL is running: `sudo systemctl status mysql`
- Verify the database name is correct

**No quotes showing:**
- Check if quotes are approved: `SELECT COUNT(*) FROM quotes WHERE approved = '1';`
- If 0, run the UPDATE command in step 3 above

**Can't vote:**
- Check that the votes table exists
- Verify your IP isn't already in the votes table for that quote

Enjoy your recovered quote database! 🎉
